#include <algorithm>
#include <cmath>
#include <iostream>
#include <vector>

using namespace std;

struct Move {
    int id;
    long long x;
    long long y;
    double angle;
};

bool compare(const Move &a, const Move &b) { return a.angle < b.angle; }

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    cin >> n;
    vector<Move> moves(n);

    for (int i = 0; i < n; i++) {
        Move m;
        m.id = i + 1;
        cin >> m.x >> m.y;
        m.angle = atan2(m.y, m.x);
        moves[i] = m;
    }

    sort(moves.begin(), moves.end(), compare);
    moves.reserve(2 * n);
    for (int i = 0; i < n; i++) {
        Move m = moves[i];
        m.angle += 2 * M_PI;
        moves.push_back(m);
    }

    int left = 0, l = 0, r = -1;
    long long x = 0, y = 0, maxDist = 0;
    for (int right = 0; right < 2 * n; right++) {
        x += moves[right].x;
        y += moves[right].y;

        while (moves[right].angle - moves[left].angle > M_PI) {
            x -= moves[left].x;
            y -= moves[left].y;
            left++;
        }

        long long dist = (x * x) + (y * y);
        if (dist > maxDist) {
            maxDist = dist;
            l = left;
            r = right;
        }
    }

    if (r == -1) {
        cout << 0 << endl;
        return 0;
    }

    cout << r - l + 1 << endl;
    for (int i = l; i < r; i++) {
        cout << moves[i].id << " ";
    }

    cout << moves[r].id << endl;
    return 0;
}